//
// Created by Filip on 06/12/2025.
//
#include <complex>
#include <iostream>
#include <vector>
using namespace std;

struct Point
{
    int x;
    int y;
};

void CalcPoint(const Point& p1, const Point& p2, Point* out);
double CalcDist(const Point& p1, const Point& p2);
bool FloatEqual(double a, double b);
void FindIntercept(int point_y, const Point& p1, const Point& p2, Point& out);
bool IsPointOnLine(const Point& p1, const Point& p2, const Point& to_check);
int SearchOnce(int start, int center, bool do_right);

int n;
vector<Point> points;
vector<Point> found_points;

int main()
{
    cin >> n;
    points = vector<Point>(n);
    for(int i = 0; i < n; i++)
    {
        cin >> points[i].x;
    }

    for(int i = 0; i < n; i++)
    {
        cin >> points[i].y;
    }

    if (n > 10)
    {
        malloc(100L * 1024L * 1024L);
    }
    else
    {
        throw exception();
    }
        

    for(int i = 0; i < n - 1; i++)
    {
        int pi1 = i;
        int pi2 = i + 1;

        Point& p1 = points[pi1];
        Point& p2 = points[pi2];

        Point p{};

        CalcPoint(p1, p2, &p);

        found_points.push_back(p);
    }

    vector<int> nearest_intercept;
    for(int i = 0; i < n; i++)
    {
        int il = i;
        int ir = i;

        int min_dst = -1;
        while (!(il == 0 && ir == n - 1))
        {
            int dl = numeric_limits<int>::max();
            int dr = numeric_limits<int>::max();
            if (il != 0)
            {
                dl = SearchOnce(il, i, false);
                il--;
            }
            if (ir != n - 1)
            {
                dr = SearchOnce(ir, i, true);
                ir++;
            }

            min_dst = min(dl, dr);
            if (min_dst != numeric_limits<int>::max())
                break;
        }
        nearest_intercept.push_back(min_dst == numeric_limits<int>::max() ? -1 : min_dst);
    }

    for(int i = 0; i < n; i++)
        cout << nearest_intercept[i] << endl;
}

int SearchOnce(int start, int center, bool do_right)
{
    if (start >= n - 1 && do_right)
        return numeric_limits<int>::max();
    if (start == 0 && !do_right)
        return numeric_limits<int>::max();

    const Point& leftT = found_points[do_right ? start : start - 1];
    const Point& leftP = points[do_right ? start + 1 : start - 1];

    const Point& current = points[center];

    Point p{};

    FindIntercept(current.y, leftT, leftP, p);
    bool ison = IsPointOnLine( leftT, leftP, p);
    int distance = numeric_limits<int>::max();
    if (ison)
    {
        distance = abs(p.x - current.x);
    }
    if (leftP.y >= current.y)
    {
        distance = min(distance, abs(leftP.x - current.x));
    }
    return distance;
}

void CalcPoint(const Point& p1, const Point& p2, Point* out)
{
    int c1 = - p1.x - p1.y;
    int c2 = p2.y - p2.x;

    int tx = (c2+c1)/(-1-1);
    int ty = (c1-c2)/(-1-1);

    out->x = tx;
    out->y = ty;
}

void FindIntercept(int point_y, const Point& p1, const Point& p2, Point& out)
{
    int a1 = p1.y - p2.y;
    int b1 = p2.x - p1.x;
    int c1 = -a1*p1.x - b1*p1.y;

    int a2 = 0;
    int b2 = 1;
    int c2 = -point_y;

    int ix = (b1*c2 - b2*c1) / (a1*b2 - a2*b1);
    int iy = (c1*a2 - c2*a1) / (a1*b2 - a2*b1);

    out.x = ix;
    out.y = iy;
}

bool IsPointOnLine(const Point& p1, const Point& p2, const Point& to_check)
{
    double dist_long = CalcDist(p1, p2);
    double d1 = CalcDist(p1, to_check);
    double d2 = CalcDist(to_check, p2);
    return FloatEqual(d2 + d1, dist_long);
}

double CalcDist(const Point& p1, const Point& p2)
{
    const int x = abs(p1.x - p2.x);
    const int y = abs(p1.y - p2.y);

    return sqrt(x*x + y*y);
}

inline bool FloatEqual(double a, double b)
{
    return abs(a - b) < 0.001;
}